/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.core.plugin;

public interface IRSCompressor {
    public float getPressureCap();

    public float getPressure();

    public void setPressure(float var1);

    public float getTriggerPressure();

    public boolean getTriggered();

    public void setTriggered(boolean var1);

    default public void feed(float dp) {
        this.setPressure(this.getPressure() + dp);
        if (this.getPressure() > this.getPressureCap()) {
            this.setPressure(this.getPressureCap());
        }
    }

    default public void bleed(float dp) {
        this.setPressure(this.getPressure() - dp);
        if (this.getPressure() < 0.0f) {
            this.setPressure(0.0f);
        }
    }

    default public void runCompressor(boolean flag, float dp) {
        if (this.getPressure() < this.getTriggerPressure()) {
            this.setTriggered(true);
        }
        if (flag && this.getTriggered()) {
            this.feed(dp);
            if (this.getPressure() >= this.getPressureCap()) {
                this.setPressure(this.getPressureCap());
                this.setTriggered(false);
            }
        }
    }
}

