/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.loco;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.row.RoW;
import net.row.entity.EntityCartRider;
import net.row.helpers.RotativePoint;
import net.row.item.ItemKey;
import net.row.registry.RoWConfig;
import net.row.stock.core.RoWLocomotive;
import net.row.stock.core.RoWRollingStock;
import net.row.stock.core.object.RSDoor;
import net.row.stock.core.plugin.IRSCompressor;
import net.row.stock.core.plugin.IRSRegulatorD5;
import net.row.stock.core.plugin.IRSReverseD3;

public class LocoSSW
extends RoWLocomotive
implements IRSReverseD3,
IRSRegulatorD5,
IRSCompressor {
    private IRSReverseD3.EnumReserveP3 reverseP3 = IRSReverseD3.EnumReserveP3.NEUTRAL;
    private IRSRegulatorD5.EnumRegulatorP5 regulatorP5 = IRSRegulatorD5.EnumRegulatorP5.STOP;
    private float pressure;
    private boolean compressorTriggered;
    public RSDoor RSDoor;
    public byte doorTime;

    public LocoSSW(World par1World) {
        super(par1World);
        this.hasLight = true;
        this.func_70105_a(2.875f, 3.75f);
        this.bareMass = 30.0f;
        this.maxForce = 29.02f;
        this.releaseSpeed = 0.24f;
        this.forceScale = 30.0f;
        this.fuelCap = 18000;
        this.maxLabelSize = (byte)12;
        this.riderPos = new RotativePoint(this, -0.875f, 2.0625f, 0.0f);
        this.lightsPos = new RotativePoint(this, 0.0f, 0.125f, 0.0f);
        this.frontCouplerShift = 3.6875f;
        this.rearCouplerShift = 3.6875f;
        this.dismountPosRight = new RotativePoint(this, -2.3125f, 1.0f, -0.3125f);
        this.dismountPosLeft = new RotativePoint(this, 2.3125f, 1.0f, -0.3125f);
        this.walkableMinX = -0.875f;
        this.walkableMaxX = 0.875f;
        this.walkableMaxZ = 0.25f;
        this.walkableMinZ = -0.5f;
        this.hornSound = "horn_ssw";
        this.label = "SSW";
        this.wheelRadius = new float[]{0.5625f};
        this.wheelAngle = new float[]{0.0f};
        this.axleShifts = new float[]{2.75f};
        this.doorTime = (byte)4;
        this.RSDoor = new RSDoor(this.doorTime);
        this.couplerFrontType = RoWRollingStock.CouplerType.BnC_RUSS;
        this.couplerRearType = RoWRollingStock.CouplerType.BnC_RUSS;
    }

    @Override
    public void addLoopingSounds() {
        super.addLoopingSounds();
        RoW.proxy.playSSWMotor(this);
        RoW.proxy.playCompressor(this);
    }

    @Override
    public boolean func_130002_c(EntityPlayer player) {
        ItemStack stack;
        if (!this.field_70170_p.field_72995_K && (stack = player.func_71045_bC()) != null && stack.func_77973_b() instanceof ItemKey && stack.field_77994_a > 0 && this.RSDoor.tryTrigger()) {
            if (this.RSDoor.isOpened()) {
                this.field_70170_p.func_72956_a((Entity)this, "row:door_open", 1.0f, 1.0f);
            } else {
                this.field_70170_p.func_72956_a((Entity)this, "row:door_close", 1.0f, 1.0f);
            }
            this.sendUpdateToClient();
            return true;
        }
        return super.func_130002_c(player);
    }

    @Override
    public boolean interactMount(EntityPlayer player) {
        if (this.canBeRidden() && player.field_70154_o == null && !player.func_70093_af() && this.RSDoor.isFullyOpened()) {
            this.seat = new EntityCartRider(this);
            this.field_70170_p.func_72838_d((Entity)this.seat);
            player.func_70078_a((Entity)this.seat);
            if (RoWConfig.automaticDoorClose) {
                this.RSDoor.tryTrigger();
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72956_a((Entity)this, "row:door_close", 1.0f, 1.0f);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.RSDoor.onUpdate();
    }

    @Override
    public void handleMass() {
        this.workingMass = this.bareMass + 2.0f * (float)this.fuel / (float)this.fuelCap;
    }

    @Override
    public boolean canMount() {
        return this.RSDoor.isFullyOpened();
    }

    @Override
    public boolean canDismount() {
        return this.RSDoor.isFullyOpened();
    }

    @Override
    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public boolean getTriggered() {
        return this.compressorTriggered;
    }

    @Override
    public void setTriggered(boolean t) {
        this.compressorTriggered = t;
    }

    @Override
    public float getPressureCap() {
        return 500.0f;
    }

    @Override
    public float getPressure() {
        return this.pressure;
    }

    @Override
    public float getTriggerPressure() {
        return 100.0f;
    }

    @Override
    public void setPressure(float p) {
        this.pressure = p;
    }

    @Override
    public IRSReverseD3.EnumReserveP3 getReverse() {
        return this.reverseP3;
    }

    @Override
    public void setReverse(IRSReverseD3.EnumReserveP3 state) {
        this.reverseP3 = state;
    }

    @Override
    public IRSRegulatorD5.EnumRegulatorP5 getRegulator() {
        return this.regulatorP5;
    }

    @Override
    public void setRegulator(IRSRegulatorD5.EnumRegulatorP5 state) {
        this.regulatorP5 = state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnFx() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnWhistleFx() {
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.RSDoor = new RSDoor(this.doorTime, tag.func_74771_c("stage"), tag.func_74767_n("opened"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("opened", this.RSDoor.isOpened());
        tag.func_74774_a("stage", this.RSDoor.getStage());
    }
}

