/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.apiimpl.v1;

import com.InfinityRaider.AgriCraft.api.API;
import com.InfinityRaider.AgriCraft.api.APIBase;
import com.InfinityRaider.AgriCraft.api.APIStatus;
import com.InfinityRaider.AgriCraft.api.v1.APIv1;
import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IAgriCraftPlant;
import com.InfinityRaider.AgriCraft.api.v1.ICropPlant;
import com.InfinityRaider.AgriCraft.api.v1.IFertiliser;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.IMutation;
import com.InfinityRaider.AgriCraft.api.v1.ItemWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.SeedRequirementStatus;
import com.InfinityRaider.AgriCraft.api.v2.IRake;
import com.InfinityRaider.AgriCraft.api.v2.ISeedStats;
import com.InfinityRaider.AgriCraft.blocks.BlockCrop;
import com.InfinityRaider.AgriCraft.blocks.BlockModPlant;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.PlantStats;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlantAPIv1;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlantAgriCraft;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.Mutation;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationHandler;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.init.Blocks;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.utility.exception.MissingArgumentsException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class APIimplv1
implements APIv1 {
    private final int version;
    private final APIStatus status;
    private static final Random random = new Random();

    public APIimplv1(int version, APIStatus status) {
        this.version = version;
        this.status = status;
    }

    @Override
    public APIBase getAPI(int maxVersion) {
        if (maxVersion == this.version && this.status == APIStatus.OK) {
            return this;
        }
        return API.getAPI(maxVersion);
    }

    @Override
    public APIStatus getStatus() {
        return this.status;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isActive(World world) {
        return true;
    }

    @Override
    public List<ItemStack> getCropsItems() {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(com.InfinityRaider.AgriCraft.init.Items.crops)});
    }

    @Override
    public List<ItemStack> getRakeItems() {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(com.InfinityRaider.AgriCraft.init.Items.handRake, 1, 0), new ItemStack(com.InfinityRaider.AgriCraft.init.Items.handRake, 1, 1)});
    }

    @Override
    public List<Block> getCropsBlocks() {
        return Lists.newArrayList((Object[])new Block[]{Blocks.blockCrop});
    }

    @Override
    public boolean isNativePlantingDisabled(ItemStack seed) {
        return ConfigurationHandler.disableVanillaFarming;
    }

    @Override
    public boolean isHandledByAgricraft(ItemStack seed) {
        return CropPlantHandler.isValidSeed(seed);
    }

    @Override
    public ISeedStats getSeedStats(ItemStack seed) {
        if (!this.isHandledByAgricraft(seed)) {
            return null;
        }
        if (seed.field_77990_d != null && seed.field_77990_d.func_74764_b("growth") && seed.field_77990_d.func_74767_n("analyzed")) {
            return PlantStats.readFromNBT(seed.field_77990_d);
        }
        return new PlantStats(-1, -1, -1);
    }

    @Override
    public void registerCropPlant(ICropPlant plant) {
        CropPlantHandler.addCropToRegister(new CropPlantAPIv1(plant));
    }

    @Override
    public ICropPlant getCropPlant(ItemStack seed) {
        return CropPlantHandler.getPlantFromStack(seed);
    }

    @Override
    public void registerCropPlant(IAgriCraftPlant plant) {
        CropPlantHandler.addCropToRegister(new CropPlantAgriCraft(plant));
    }

    @Override
    public boolean registerGrowthRequirement(ItemWithMeta seed, IGrowthRequirement requirement) {
        return CropPlantHandler.setGrowthRequirement(seed, requirement);
    }

    @Override
    public boolean registerDefaultSoil(BlockWithMeta soil) {
        return GrowthRequirementHandler.addDefaultSoil(soil);
    }

    @Override
    public IGrowthRequirement getGrowthRequirement(ItemStack seed) {
        if (!CropPlantHandler.isValidSeed(seed)) {
            return null;
        }
        return CropPlantHandler.getGrowthRequirement(seed);
    }

    @Override
    public boolean canPlaceCrops(World world, int x, int y, int z, ItemStack crops) {
        if (crops == null || crops.func_77973_b() == null || crops.func_77973_b() != com.InfinityRaider.AgriCraft.init.Items.crops) {
            return false;
        }
        return GrowthRequirementHandler.isSoilValid(world, x, y - 1, z) && world.func_147437_c(x, y, z);
    }

    @Override
    public boolean placeCrops(World world, int x, int y, int z, ItemStack crops) {
        if (this.canPlaceCrops(world, x, y, z, crops) && crops.field_77994_a >= 1) {
            if (!world.field_72995_K) {
                world.func_147465_d(x, y, z, Blocks.blockCrop, 0, 3);
                --crops.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCrops(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == Blocks.blockCrop;
    }

    @Override
    public boolean isMature(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            return crop.hasPlant() && crop.isMature();
        }
        return false;
    }

    @Override
    public boolean isWeeds(World world, int x, int y, int z) {
        if (!ConfigurationHandler.enableWeeds) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            return crop.hasWeed();
        }
        return false;
    }

    @Override
    public boolean isEmpty(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            return !crop.isCrossCrop() && !crop.hasWeed() && !crop.hasPlant();
        }
        return false;
    }

    @Override
    public boolean isCrossCrops(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            return crop.isCrossCrop();
        }
        return false;
    }

    @Override
    public ItemStack getPlantedSeed(World world, int x, int y, int z) {
        if (!this.isCrops(world, x, y, z)) {
            return null;
        }
        return ((TileEntityCrop)world.func_147438_o(x, y, z)).getSeedStack();
    }

    @Override
    public Block getPlantedBlock(World world, int x, int y, int z) {
        if (!this.isCrops(world, x, y, z)) {
            return null;
        }
        return ((TileEntityCrop)world.func_147438_o(x, y, z)).getPlantBlock();
    }

    @Override
    public ICropPlant getCropPlant(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityCrop)) {
            return null;
        }
        return ((TileEntityCrop)te).getPlant();
    }

    @Override
    public boolean canGrow(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            return crop.hasPlant() && crop.isFertile();
        }
        return false;
    }

    @Override
    public boolean isAnalyzed(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityCrop)) {
            return false;
        }
        TileEntityCrop crop = (TileEntityCrop)te;
        return crop.hasPlant() && crop.isAnalyzed();
    }

    @Override
    public ISeedStats getStats(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityCrop)) {
            return new PlantStats(-1, -1, -1);
        }
        TileEntityCrop crop = (TileEntityCrop)te;
        return crop.getStats();
    }

    @Override
    public boolean isRakeRequiredForWeeding() {
        return ConfigurationHandler.enableHandRake;
    }

    @Override
    public boolean removeWeeds(World world, int x, int y, int z, boolean byHand) {
        if (!ConfigurationHandler.enableWeeds || byHand && ConfigurationHandler.enableHandRake) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (!crop.hasWeed()) {
                return false;
            }
            if (!world.field_72995_K) {
                crop.updateWeed(0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeWeeds(World world, int x, int y, int z, ItemStack rake) {
        if (world.field_72995_K) {
            return false;
        }
        if (!ConfigurationHandler.enableWeeds) {
            return false;
        }
        if (rake == null || rake.func_77973_b() == null || !(rake.func_77973_b() instanceof IRake)) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (!crop.hasWeed()) {
                return false;
            }
            return ((IRake)rake.func_77973_b()).removeWeeds(crop, rake);
        }
        return false;
    }

    @Override
    public boolean placeCrossCrops(World world, int x, int y, int z, ItemStack crops) {
        TileEntityCrop crop;
        if (world.field_72995_K) {
            return false;
        }
        if (crops == null || crops.func_77973_b() == null || crops.func_77973_b() != com.InfinityRaider.AgriCraft.init.Items.crops || crops.field_77994_a < 1) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop && !(crop = (TileEntityCrop)te).hasWeed() && !crop.isCrossCrop() && !crop.hasPlant()) {
            crop.setCrossCrop(true);
            --crops.field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack removeCrossCrops(World world, int x, int y, int z) {
        TileEntityCrop crop;
        if (world.field_72995_K) {
            return null;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop && (crop = (TileEntityCrop)te).isCrossCrop()) {
            crop.setCrossCrop(false);
            return new ItemStack(com.InfinityRaider.AgriCraft.init.Items.crops, 1);
        }
        return null;
    }

    @Override
    public SeedRequirementStatus canApplySeeds(World world, int x, int y, int z, ItemStack seed) {
        if (CropPlantHandler.isValidSeed(seed)) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityCrop) {
                TileEntityCrop crop = (TileEntityCrop)te;
                if (crop.isCrossCrop() || crop.hasPlant() || crop.hasWeed()) {
                    return SeedRequirementStatus.BAD_LOCATION;
                }
                IGrowthRequirement growthRequirement = CropPlantHandler.getGrowthRequirement(seed);
                if (!growthRequirement.isValidSoil(world, x, y - 1, z)) {
                    return SeedRequirementStatus.WRONG_SOIL;
                }
                if (!growthRequirement.canGrow(world, x, y, z)) {
                    return SeedRequirementStatus.MISSING_REQUIREMENTS;
                }
                return SeedRequirementStatus.CAN_APPLY;
            }
            return SeedRequirementStatus.BAD_LOCATION;
        }
        return SeedRequirementStatus.BAD_SEED;
    }

    @Override
    public boolean applySeeds(World world, int x, int y, int z, ItemStack seed) {
        TileEntity te;
        if (!world.field_72995_K && CropPlantHandler.isValidSeed(seed) && (te = world.func_147438_o(x, y, z)) instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (crop.isCrossCrop() || crop.hasPlant() || crop.hasWeed() || !CropPlantHandler.getGrowthRequirement(seed).canGrow(world, x, y, z)) {
                return false;
            }
            if (seed.field_77990_d != null && seed.field_77990_d.func_74764_b("growth")) {
                crop.setPlant(seed.field_77990_d.func_74762_e("growth"), seed.field_77990_d.func_74762_e("gain"), seed.field_77990_d.func_74762_e("strength"), seed.field_77990_d.func_74767_n("analyzed"), seed.func_77973_b(), seed.func_77960_j());
            } else {
                crop.setPlant(1, 1, 1, false, seed.func_77973_b(), seed.func_77960_j());
            }
            --seed.field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> harvest(World world, int x, int y, int z) {
        TileEntityCrop crop;
        if (world.field_72995_K) {
            return null;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop && (crop = (TileEntityCrop)te).allowHarvest(null)) {
            crop.func_145831_w().func_72921_c(crop.field_145851_c, crop.field_145848_d, crop.field_145849_e, 2, 2);
            return crop.getPlant().getFruitsOnHarvest(crop.getGain(), world.field_73012_v);
        }
        return null;
    }

    @Override
    public List<ItemStack> destroy(World world, int x, int y, int z) {
        if (world.field_72995_K || !this.isCrops(world, x, y, z)) {
            return null;
        }
        ArrayList result = Blocks.blockCrop.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
        world.func_147475_p(x, y, z);
        return result;
    }

    @Override
    public boolean isSupportedFertilizer(ItemStack fertilizer) {
        if (fertilizer == null || fertilizer.func_77973_b() == null) {
            return false;
        }
        if (fertilizer.func_77973_b() == Items.field_151100_aR && fertilizer.func_77960_j() == 15) {
            return true;
        }
        return fertilizer.func_77973_b() instanceof IFertiliser;
    }

    @Override
    public boolean isValidFertilizer(World world, int x, int y, int z, ItemStack fertilizer) {
        if (fertilizer == null || fertilizer.func_77973_b() == null) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (fertilizer.func_77973_b() == Items.field_151100_aR && fertilizer.func_77960_j() == 15) {
                return crop.canBonemeal();
            }
            if (fertilizer.func_77973_b() instanceof IFertiliser) {
                return crop.allowFertiliser((IFertiliser)fertilizer.func_77973_b());
            }
        }
        return false;
    }

    @Override
    public boolean applyFertilizer(World world, int x, int y, int z, ItemStack fertilizer) {
        if (world.field_72995_K || !this.isValidFertilizer(world, x, y, z, fertilizer)) {
            return false;
        }
        if (fertilizer.func_77973_b() == Items.field_151100_aR && fertilizer.func_77960_j() == 15) {
            ((BlockCrop)Blocks.blockCrop).func_149853_b(world, random, x, y, z);
            --fertilizer.field_77994_a;
            world.func_72926_e(2005, x, y, z, 0);
            return true;
        }
        if (fertilizer.func_77973_b() instanceof IFertiliser) {
            ((TileEntityCrop)world.func_147438_o(x, y, z)).applyFertiliser((IFertiliser)fertilizer.func_77973_b(), world.field_73012_v);
            --fertilizer.field_77994_a;
            world.func_72926_e(2005, x, y, z, 0);
            return true;
        }
        return false;
    }

    @Override
    public IMutation[] getRegisteredMutations() {
        return MutationHandler.getInstance().getMutations();
    }

    @Override
    public IMutation[] getRegisteredMutationsForParent(ItemStack parent) {
        return MutationHandler.getInstance().getMutationsFromParent(parent);
    }

    @Override
    public IMutation[] getRegisteredMutationsForChild(ItemStack child) {
        return MutationHandler.getInstance().getMutationsFromChild(child);
    }

    @Override
    public boolean registerMutation(ItemStack result, ItemStack parent1, ItemStack parent2) {
        MutationHandler.getInstance().add(new Mutation(result, parent1, parent2));
        return false;
    }

    @Override
    public boolean registerMutation(ItemStack result, ItemStack parent1, ItemStack parent2, double d) {
        MutationHandler.getInstance().add(new Mutation(result, parent1, parent2, d));
        return true;
    }

    @Override
    public boolean removeMutation(ItemStack result) {
        MutationHandler.getInstance().removeMutationsByResult(result);
        return true;
    }

    @Override
    public IAgriCraftPlant createNewCrop(Object ... args) {
        try {
            return new BlockModPlant(args);
        }
        catch (MissingArgumentsException e) {
            e.printStackTrace();
            return null;
        }
    }
}

